'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Report_Activate()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
    Me.Caption = "Preise: Kalender/Kategorie"
    
    'Abfrage mit 0 Datenstzen abfangen
    If Me.HasData = 0 Then
        Me.Detailbereich.Visible = False
        Me.Kopf2.Visible = False
        Me.Text_Kopf1.Visible = False
        Me.Bez_KeineErgebnisse.Visible = True
    Else
        Me.Detailbereich.Visible = True
        Me.Kopf2.Visible = True
        Me.Text_Kopf1.Visible = True
        Me.Bez_KeineErgebnisse.Visible = False
    End If
End Sub

Private Sub Report_Open(Cancel As Integer)
    'Schriftart einstellen
    SchriftartFuerBerichtEinstellen Me
    Me.ImpFusszeile.Caption = ImpressumBerichtsfuss
    Me.Text_SatzKategorieDummy.Caption = SatzKategorieDummy

    'aktuelles Whrungsformat des Systems einstellen
    Me.Text57.Format = "Currency"
    
    Me.Filter = BerichteFilter
    Me.FilterOn = True
    
    'Anzeigen einstellen
    If InStr(1, BerichteFilter, "lfd_Nr_Kalender") Then
        'der Bericht ist nach Kalender und Kategorie gefiltert
        Me.Text_AllePreise.Visible = False
        Me.Text_GefiltertePreise.Visible = True
        Me.Text_Kalender.Visible = True
        Me.Text_Kategorie.Visible = True
        Me.Wert_Kalender.Visible = True
        Me.Wert_Kategorie.Visible = True
        If RePreisJeKalender = True Then
            Me.Wert_Kalender.Caption = "Ja"
        Else
            Me.Wert_Kalender.Caption = "Nein"
        End If
        If RePreisJeKategorie = True Then
            Me.Wert_Kategorie.Caption = "Ja"
        Else
            Me.Wert_Kategorie.Caption = "Nein"
        End If
    Else
        'es sollen alle Preise je Kategorie/Kalender angezeigt werden
        Me.Text_AllePreise.Visible = True
        Me.Text_GefiltertePreise.Visible = False
        Me.Text_Kalender.Visible = False
        Me.Text_Kategorie.Visible = False
        Me.Wert_Kalender.Visible = False
        Me.Wert_Kategorie.Visible = False
    End If
    
    Me.Ueberschrift.Caption = BerichteUeberschrift
    
End Sub
